{*
* @author	Krzysztof Pecak
* @copyright	2017 Krzysztof Pecak
* @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*}

<div id="home_man_product">

	{foreach from=$manProducts item=manProduct name=atManProducts}
		
		<div id="block_id_{$manProduct.id|escape:'htmlall':'UTF-8'}" class="manprod_block">

			<h4 class="catprod_title ">
				<a href="{$link->getManufacturerLink({$manProduct.id|escape:'htmlall':'UTF-8'},{$manProduct.link_rewrite})|escape:'html':'UTF-8'}" title="{$manProduct.name|escape:'htmlall':'UTF-8'}">
					<span>{$manProduct.name|escape:'htmlall':'UTF-8'}</span>
				</a>
				<div id="man_home-next_{$manProduct.id|escape:'htmlall':'UTF-8'}" class="slider-btn"></div>
				<div id="man_home-prev_{$manProduct.id|escape:'htmlall':'UTF-8'}" class="slider-btn"></div>
			</h4>

			<div class="bx_box">
				<ul id="man_bxslider_{$manProduct.id|escape:'htmlall':'UTF-8'}">
					{foreach from=$manProduct.product item=product name=myLoop}
					<li>
						
						<div class="product_container">
							<div class="left-block">
								<a class="product_img_link" href="{$product.link|escape:'html':'UTF-8'}" title="{$product.name|escape:'html':'UTF-8'}" itemprop="url">
									<img class="replace-2x img-responsive" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'small_default')|escape:'html':'UTF-8'}" alt="{if !empty($product.legend)}{$product.legend|escape:'html':'UTF-8'}{else}{$product.name|escape:'html':'UTF-8'}{/if}" title="{if !empty($product.legend)}{$product.legend|escape:'html':'UTF-8'}{else}{$product.name|escape:'html':'UTF-8'}{/if}" {if isset($smallSize)} width="{$smallSize.width}" height="{$smallSize.height}"{/if} itemprop="image" />
								</a>

								<a href="{$product.link|escape:'html':'UTF-8'}" class="product-flags">
									{if isset($product.new) && $product.new == 1}
										<span class="product-flag new">{l s='New' mod='angarmanproduct'}</span>
									{/if}

									{if $product.discount_type === 'percentage'}
										<span class="product-flag on-sale">{$product.discount_percentage}</span>
									{/if}

								</a>
							</div>

							<div class="right-block">
								<h5 itemprop="name">
									{if isset($product.pack_quantity) && $product.pack_quantity}{$product.pack_quantity|intval|cat:' x '}{/if}
									<a class="product-name" href="{$product.link|escape:'html':'UTF-8'}" title="{$product.name|escape:'html':'UTF-8'}" itemprop="url" >
										{$product.name|truncate:45:'...'|escape:'html':'UTF-8'}
									</a>
								</h5>
								{capture name='displayProductListReviews'}{hook h='displayProductListReviews' product=$product}{/capture}
								{if $smarty.capture.displayProductListReviews}
									<div class="hook-reviews">
										{hook h='displayProductListReviews' product=$product}
									</div>
								{/if}

								{block name='product_shortdesc'}
									<p class="product-desc" itemprop="description">
										{$product.description_short|strip_tags:'UTF-8'|truncate:40:'...'}
									</p>
								{/block}

								{if $product.show_price}
									<div class="product-price-and-shipping">
										{hook h='displayProductPriceBlock' product=$product type="before_price"}

										<span itemprop="price" class="price">{$product.price}</span>

										{if $product.has_discount}
											{hook h='displayProductPriceBlock' product=$product type="old_price"}
											<span class="regular-price">{$product.regular_price}</span>
										{/if}

										{hook h='displayProductPriceBlock' product=$product type='unit_price'}
										{hook h='displayProductPriceBlock' product=$product type='weight'}
									</div>
								{/if}
							</div>

							<div class="clearfix"></div>

						</div>

					</li>
					{/foreach}
				</ul>

			</div>

		</div>

	{/foreach}

</div>

<div class="clearfix"></div>

