{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}

{* AngarTheme *}

{block name='product_miniature_item'}
  <article class="product-miniature js-product-miniature" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
    <div class="thumbnail-container">

		<div class="product-left">
			<div class="product-image-container">
				{block name='product_flags'}
				<a href="{$product.url}" class="product-flags">
					{if $product.discount_type === 'percentage'}
						<span class="product-flag discount-percentage">{$product.discount_percentage}</span>
					{/if}
					{foreach from=$product.flags|@array_reverse item=flag}
						<span class="product-flag {$flag.type}">{$flag.label}</span>
					{/foreach}
				</a>
				{/block}

				{block name='product_thumbnail'}
				<a href="{$product.url}" class="thumbnail product-thumbnail">
				  <img
					src = "{$product.cover.bySize.home_default.url}"
					alt = "{if !empty($product.cover.legend)}{$product.cover.legend}{else}{$product.name|truncate:30:'...'}{/if}"
					data-full-size-image-url = "{$product.cover.large.url}"
				  >
				</a>
				{/block}

				{block name='quick_view'}
				  <a class="quick-view" href="#" data-link-action="quickview">
					<i class="material-icons search">&#xE8B6;</i>{l s='Quick view' d='Shop.Theme.Actions'}
				  </a>
				{/block}
			</div>
		</div>


		<div class="product-right">
			<div class="product-description">
				{block name='product_name'}
				  <h1 class="h3 product-title" itemprop="name"><a href="{$product.url}">{$product.name|truncate:160:'...'}</a></h1>
				{/block}

				{block name='product_reviews'}
				  {hook h='displayProductListReviews' product=$product}
				{/block}

				{block name='product_shortdesc'}
					<p class="product-desc" itemprop="description">
						{$product.description_short|strip_tags:'UTF-8'|truncate:360:'...'}
					</p>
				{/block}
			</div>

			<div class="product-bottom">
				{block name='product_price_and_shipping'}
				  {if $product.show_price}
					<div class="product-price-and-shipping">
					  {hook h='displayProductPriceBlock' product=$product type="before_price"}

					  <span class="sr-only">{l s='Price' d='Shop.Theme.Catalog'}</span>
					  <span itemprop="price" class="price">{$product.price}</span>

					  {if $product.has_discount}
						{hook h='displayProductPriceBlock' product=$product type="old_price"}
						<span class="sr-only">{l s='Regular price' d='Shop.Theme.Catalog'}</span>
						<span class="regular-price">{$product.regular_price}</span>
					  {/if}

					  {hook h='displayProductPriceBlock' product=$product type='unit_price'}

					  {hook h='displayProductPriceBlock' product=$product type='weight'}
					</div>
				  {/if}
				{/block}

				<div class="button-container">
					<form action="{$urls.pages.cart}" method="post" class="add-to-cart-or-refresh">
					  <input type="hidden" name="token" value="{$static_token}">
					  <input type="hidden" name="id_product" value="{$product.id}" class="product_page_product_id">
					  <input type="hidden" name="qty" value="1">
					  <button class="btn add-to-cart" data-button-action="add-to-cart" type="submit" {if $product.quantity < 1 }disabled{/if}>
						<i class="material-icons shopping-cart"></i>
						{l s='Add to cart' d='Shop.Theme.Actions'}
					  </button>
					</form>

					<a class="button lnk_view btn btn-default" href="{$product.link|escape:'html':'UTF-8'}" title="{l s='View'}">
						<span>{if (isset($product.customization_required) && $product.customization_required)}{l s='Customize'}{else}{l s='More'}{/if}</span>
					</a>
				</div>

				<div class="availability">
				{block name='product_availability'}
				  <span id="product-availability">
					{if $product.show_availability && $product.availability_message}
					  {if $product.availability == 'available'}
						<i class="material-icons product-available">&#xE5CA;</i>
					  {elseif $product.availability == 'last_remaining_items'}
						<i class="material-icons product-last-items">&#xE002;</i>
					  {else}
						<i class="material-icons product-unavailable">&#xE14B;</i>
					  {/if}
					  {$product.availability_message}
					{/if}
				  </span>
				{/block}
				</div>

				<div class="highlighted-informations{if !$product.main_variants} no-variants{/if} hidden-sm-down">
					{block name='product_variants'}
					  {if $product.main_variants}
						{include file='catalog/_partials/variant-links.tpl' variants=$product.main_variants}
					  {/if}
					{/block}
				</div>
			</div>
		</div>

		<div class="clearfix"></div>

    </div>
  </article>
{/block}
